/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer;

import bre.fpsreducer.FpsReducerConfig;
import bre.fpsreducer.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class WakeupEventHandler {
    Minecraft mc = Minecraft.func_71410_x();
    static long idleStartTime;
    static int currentGameSettingFPS;
    static float currentGameSettingVolume;
    static boolean reduceFPS;
    static boolean stopSound;
    static long prevMouseEventNanoSec;
    static long prevKeyEventNanoSec;
    static boolean prevWindowStatus;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.mc.field_71441_e == null) {
                this.resetWaitingTimer();
                this.recoverFPS();
                return;
            }
            if (FpsReducerConfig.reducingInBackground || FpsReducerConfig.suppressSound) {
                boolean curWindowStatus = Display.isActive();
                if (!curWindowStatus) {
                    if (curWindowStatus != prevWindowStatus) {
                        Logger.debug("Window has been inactive.");
                        prevWindowStatus = curWindowStatus;
                        if (FpsReducerConfig.reducingInBackground) {
                            this.reduceFPS();
                        }
                        if (FpsReducerConfig.suppressSound) {
                            this.stopSound();
                        }
                    }
                    return;
                }
                if (curWindowStatus != prevWindowStatus) {
                    Logger.debug("Window has been active.");
                    prevKeyEventNanoSec = Keyboard.getEventNanoseconds();
                    prevMouseEventNanoSec = Mouse.getEventNanoseconds();
                    prevWindowStatus = curWindowStatus;
                    this.recoverSound();
                }
            }
            if (!FpsReducerConfig.enableFpsReducer) {
                this.resetWaitingTimer();
                this.recoverFPS();
                return;
            }
            long currentKeyEventNanoSec = Keyboard.getEventNanoseconds();
            if (currentKeyEventNanoSec != prevKeyEventNanoSec) {
                prevKeyEventNanoSec = currentKeyEventNanoSec;
                this.resetWaitingTimer();
                this.recoverFPS();
                return;
            }
            if (this.mc.field_71439_g.field_71158_b.field_187255_c || this.mc.field_71439_g.field_71158_b.field_187256_d || this.mc.field_71439_g.field_71158_b.field_187258_f || this.mc.field_71439_g.field_71158_b.field_187257_e || this.mc.field_71439_g.field_71158_b.field_78901_c || this.mc.field_71439_g.field_71158_b.field_78899_d) {
                this.resetWaitingTimer();
                this.recoverFPS();
                return;
            }
            long currentMouseEventNanoSec = Mouse.getEventNanoseconds();
            if (currentMouseEventNanoSec != prevMouseEventNanoSec) {
                prevMouseEventNanoSec = currentMouseEventNanoSec;
                this.resetWaitingTimer();
                this.recoverFPS();
                return;
            }
            if (!FpsReducerConfig.ignoreHoldButton) {
                for (int bc = 0; bc < Mouse.getButtonCount(); ++bc) {
                    if (!Mouse.isButtonDown((int)bc)) continue;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    break;
                }
            }
            this.checkWaitingTimer();
        }
    }

    private void resetWaitingTimer() {
        idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        if (!reduceFPS && System.currentTimeMillis() - idleStartTime > (long)(FpsReducerConfig.waitingTime * 1000)) {
            this.reduceFPS();
        }
    }

    private void reduceFPS() {
        if (!reduceFPS) {
            currentGameSettingFPS = this.mc.field_71474_y.field_74350_i;
            this.mc.field_71474_y.field_74350_i = FpsReducerConfig.idleFPS;
            reduceFPS = true;
            Logger.debug("Reducing max FPS: " + this.mc.field_71474_y.field_74350_i);
        }
    }

    private void recoverFPS() {
        if (reduceFPS) {
            this.mc.field_71474_y.field_74350_i = currentGameSettingFPS;
            reduceFPS = false;
            if (this.mc.field_71474_y.field_74350_i == 260) {
                Logger.debug("Recovering max FPS: Unlimited");
            } else {
                Logger.debug("Recovering max FPS: " + this.mc.field_71474_y.field_74350_i);
            }
        }
    }

    private void stopSound() {
        if (!stopSound) {
            currentGameSettingVolume = this.mc.field_71474_y.func_186711_a(SoundCategory.MASTER);
            float newVolume = currentGameSettingVolume * (float)FpsReducerConfig.suppressedVolume / 100.0f;
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, newVolume);
            stopSound = true;
            Logger.debug("Suppressing master volume: " + (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (stopSound) {
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, currentGameSettingVolume);
            stopSound = false;
            Logger.debug("Recovering master volume: " + (int)(currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - idleStartTime) / 1000;
    }

    static {
        reduceFPS = false;
        stopSound = false;
        prevWindowStatus = true;
    }
}

